﻿using gov.va.med.vbecs.GUI;
using System;
using System.Reflection;
using System.Windows;
using WPF.PresentationLayer.UC115.ViewModels;

namespace WPF.PresentationLayer
{
    public static class ViewConstructor
    {
        private static bool _resourcesLoaded;
        private const int _formWidthAddition = 30; // 30 == space for the form margin around the control;
        private const int _formHeightAddition = 75; // 75 == space for the VBECS header

        public static F CreateFormAndView<V, F>()
            where V : FrameworkElement, new()
            where F : VbecsWPFFormBase, new()
        {
            LoadResourcesIfNeeded();

            VbecsWPFFormBase form = new F();
            FrameworkElement userControl = new V();
            // Set a unique name in the registry so the form's size and position are stored independently
            form.SetVbecsWindowStateRegistryPathFormName(form.GetType().Name + "_" + userControl.GetType().Name);

            var viewModelBase = userControl.DataContext as ViewModelBase;
            if (viewModelBase != null && userControl != null)
            {
                viewModelBase.SetVbecsBaseForm(form, true);
            }

            if (userControl.Width > 0)
            {
                form.Width = (int)userControl.Width + _formWidthAddition; 
            }
            
            if (userControl.Height > 0)
            {
                form.Height = (int)userControl.Height + _formHeightAddition; 
            }

            if (userControl.MinWidth > 0 &&
                userControl.MinHeight > 0)
            {
                form.MinimumSize = new System.Drawing.Size((int)userControl.MinWidth + _formWidthAddition, (int)userControl.MinHeight + _formHeightAddition);
            }

            form.WPFUserControl = userControl;

            return form as F;
        }

        //public static UIElement CreateView<T>() where T : FrameworkElement, new()
        //{
        //    LoadResourcesIfNeeded();

        //    FrameworkElement userControl = new T();
        //    var viewModelBase = userControl.DataContext as ViewModelBase;
        //    return userControl;
        //}

        //public static UIElement CreateView<T>(object dataContext) where T : FrameworkElement, new()
        //{
        //    LoadResourcesIfNeeded();
        //    FrameworkElement userControl = new T();
        //    userControl.DataContext = dataContext;
        //    return userControl;
        //}

        private static void LoadResourcesIfNeeded()
        {
            if (!_resourcesLoaded)
            {
                string executingAssemblyName = Assembly.GetExecutingAssembly().FullName;
                AddResourceDictionary(executingAssemblyName, "ImageDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "ColorDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "ButtonDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "CheckBoxDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "TextBlockDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "TextboxDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "MarginDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "DataGridDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "GroupBoxDictionary.xaml");
                AddResourceDictionary(executingAssemblyName, "TemplateDictionary.xaml");
                _resourcesLoaded = true;
            }
        }

        private static void AddResourceDictionary(string executingAssemblyName, string resourceName)
        {

            if (Application.Current == null)
            {
                new Application();
            }

            Application.Current.Resources.MergedDictionaries
                .Add(new ResourceDictionary
                {
                    Source = new Uri(@"pack://application:,,,/" + executingAssemblyName + ";component/Resources/" + resourceName)
                });
        }
    }
}
